/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.AmountContainer;
import com.prowidesoftware.swift.model.field.AmountResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field35U
extends Field
implements Serializable,
AmountContainer {
    public static final int SRU = 2021;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "35U";
    public static final String F_35U = "35U";
    @Deprecated
    public static final String PARSER_PATTERN = "SN[S]";
    @Deprecated
    public static final String COMPONENTS_PATTERN = "SNS";
    @Deprecated
    public static final String TYPES_PATTERN = "SIS";
    public static final Integer CURRENCY = 1;
    public static final Integer PRICE = 2;
    @Deprecated
    public static final Integer AMOUNT = 2;
    public static final Integer PERIOD = 3;

    public Field35U() {
        super(3);
    }

    public Field35U(String value) {
        super(value);
    }

    public Field35U(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"35U")) {
            throw new IllegalArgumentException("cannot create field 35U from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field35U newInstance(Field35U source) {
        Field35U cp = new Field35U();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("35U", value);
    }

    public static Tag emptyTag() {
        return new Tag("35U", "");
    }

    @Override
    public void parse(String value) {
        this.init(3);
        this.setComponent1(SwiftParseUtils.getAlphaPrefix(value));
        String toparse = this.getComponent1() == null ? value : StringUtils.substringAfter((String)value, (String)this.getComponent1());
        this.setComponent2(SwiftParseUtils.getNumericPrefix(toparse));
        this.setComponent3(SwiftParseUtils.getAlphaSuffix(toparse));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.append(result, 1);
        this.append(result, 2);
        this.append(result, 3);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 3) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 35U");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            NumberFormat f = NumberFormat.getNumberInstance(this.notNull(locale));
            f.setMaximumFractionDigits(13);
            BigDecimal n = this.getComponent2AsBigDecimal();
            if (n != null) {
                return f.format(n);
            }
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        return null;
    }

    @Override
    @Deprecated
    public String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public String typesPattern() {
        return TYPES_PATTERN;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String validatorPattern() {
        return "3!a<AMOUNT>15[1a]";
    }

    @Override
    public boolean isOptional(int component) {
        return component == 3;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 3;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Currency");
        result.add("Price");
        result.add("Period");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "currency");
        result.put(2, "price");
        result.put(3, "period");
        return result;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getCurrency() {
        return this.getComponent1();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public BigDecimal getComponent2AsBigDecimal() {
        return SwiftFormatUtils.getBigDecimal(this.getComponent(2));
    }

    @Deprecated
    public Number getComponent2AsNumber() {
        return this.getComponent2AsBigDecimal();
    }

    public String getPrice() {
        return this.getComponent2();
    }

    @Deprecated
    public String getAmount() {
        return this.getPrice();
    }

    public BigDecimal getPriceAsBigDecimal() {
        return this.getComponent2AsBigDecimal();
    }

    @Deprecated
    public Number getPriceAsNumber() {
        return this.getComponent2AsNumber();
    }

    @Deprecated
    public BigDecimal getAmountAsBigDecimal() {
        return this.getPriceAsBigDecimal();
    }

    @Deprecated
    public Number getAmountAsNumber() {
        return this.getPriceAsNumber();
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public String getPeriod() {
        return this.getComponent3();
    }

    public Field35U setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field35U setCurrency(String component1) {
        return this.setComponent1(component1);
    }

    public Field35U setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field35U setComponent2(BigDecimal component2) {
        this.setComponent(2, SwiftFormatUtils.getBigDecimal(component2));
        return this;
    }

    public Field35U setComponent2(Number component2) {
        if (component2 instanceof BigDecimal) {
            this.setComponent(2, SwiftFormatUtils.getBigDecimal((BigDecimal)component2));
        } else if (component2 instanceof BigInteger) {
            this.setComponent(2, SwiftFormatUtils.getBigDecimal(new BigDecimal((BigInteger)component2)));
        } else if (component2 instanceof Long || component2 instanceof Integer) {
            this.setComponent(2, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component2.longValue())));
        } else if (component2 != null) {
            this.setComponent(2, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component2.doubleValue())));
        } else {
            this.setComponent(2, null);
        }
        return this;
    }

    public Field35U setPrice(String component2) {
        return this.setComponent2(component2);
    }

    public Field35U setPrice(BigDecimal component2) {
        return this.setComponent2(component2);
    }

    public Field35U setPrice(Number component2) {
        return this.setComponent2(component2);
    }

    @Deprecated
    public Field35U setAmount(String component2) {
        return this.setPrice(component2);
    }

    @Deprecated
    public Field35U setAmount(BigDecimal component2) {
        return this.setPrice(component2);
    }

    @Deprecated
    public Field35U setAmount(Number component2) {
        return this.setPrice(component2);
    }

    public Field35U setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field35U setPeriod(String component3) {
        return this.setComponent3(component3);
    }

    public List<BigDecimal> amounts() {
        return AmountResolver.amounts(this);
    }

    @Override
    public BigDecimal amount() {
        return AmountResolver.amount(this);
    }

    @Override
    public String getName() {
        return "35U";
    }

    public static Field35U get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("35U");
        if (t == null) {
            return null;
        }
        return new Field35U(t);
    }

    public static Field35U get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field35U.get(msg.getBlock4());
    }

    public static List<Field35U> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field35U.getAll(msg.getBlock4());
    }

    public static List<Field35U> getAll(SwiftTagListBlock block) {
        ArrayList<Field35U> result = new ArrayList<Field35U>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("35U");
        if (arr != null && arr.length > 0) {
            for (Tag f : arr) {
                result.add(new Field35U(f));
            }
        }
        return result;
    }

    public static Field35U fromJson(String json) {
        Field35U field = new Field35U();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("currency") != null) {
            field.setComponent1(jsonObject.get("currency").getAsString());
        }
        if (jsonObject.get("amount") != null) {
            field.setComponent2(jsonObject.get("amount").getAsString());
        }
        if (jsonObject.get("price") != null) {
            field.setComponent2(jsonObject.get("price").getAsString());
        }
        if (jsonObject.get("period") != null) {
            field.setComponent3(jsonObject.get("period").getAsString());
        }
        return field;
    }
}

